TITLE   'Three Point Charges'			       	         { 3d221a.pde }
SELECT     spectral_colors					
COORDINATES     cartesian3			
DEFINITIONS                                     		
   L=1.0     d0=0.5     q=1e-10          	
   eps0=8.85e-12     c=1/(4*pi*eps0)
   U=-q*c/sqrt( x^2+(y+d0)^2+ z^2) +q*c/sqrt( x^2+(y-d0)^2+ z^2)	
        +q*c/sqrt( (x+d0)^2+y^2+ z^2)		
   Ex=-dx( U)     Ey=-dy( U)      Ez=-dz( U)     	{ Field components }
   div_xy=dx( Ex)+ dy( Ey)
   E=-grad(U)     Em=magnitude(E)
EXTRUSION			{ Extrude a cube through the (x,y) plane }
   surface 'bottom' z=-L		{ Limiting surfaces }
   surface 'top' z=L					
BOUNDARIES
region 'domain'
   start(-L,-L) 			{ Trace outer boundary of base plane }
   line to (L,-L) to (L,L) to (-L,L) close
PLOTS
   contour( U) painted on z=0     contour( U) painted on z=0.3
   contour( U) painted on x=0     contour( U) painted on y=0
   contour( U) painted on z=1.0     contour( U) painted on y=x
   vector( E) norm on z=0     vector( E) norm on z=0.3
   contour( Em) painted on z=0.3	
END

